﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.DataModel;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GroupCancelAppointment
{
    public class GetIntegrationSettingsStep:FilterBase<CancelGroupAppointmentStateObject>
    {
        public override void Execute(CancelGroupAppointmentStateObject state)
        {
            var errorString = string.Format(Strings.IntegrationSettingsErrorString, "{0}", "Cancel Group Appointment");

            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                var purposeString = Strings.ApptPurpose;
                var purpose = srv.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == purposeString);
                if (purpose == null) throw new Exception(string.Format(errorString, purposeString));
                state.AppointmentPurpose = purpose.mcs_value;

                var appointmentTypeString = Strings.ApptType;
                var type = srv.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == appointmentTypeString);
                if (type == null) throw new Exception(string.Format(errorString, appointmentTypeString));
                state.VistaAppointmentType = type.mcs_value;

                var fakeResponseTypeString = Strings.CancelFakeType;
                var fakeResponseType = srv.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == fakeResponseTypeString);
                if (fakeResponseType == null) state.CancelAppointmentFakeResponseType = string.Empty;
                else state.CancelAppointmentFakeResponseType = fakeResponseType.mcs_value;
            }
        }
    }
}
